/* NETX.h - ARM NETX header file */

/* Copyright 1999-2005 Wind River Systems, Inc. */
/* Copyright 1999-2000 ARM Limited */

/*
modification history
--------------------
01a,28feb06,awg  modified from integrator version 01w
*/

/*
This file contains I/O address and related constants for the ARM
NETX board.
*/

#ifndef	INCNetXh
#define	INCNetXh

/** BSP Variant Selection */

#ifndef BOOTLOADER

#if defined (INCLUDE_NETX_DB500SYS)
 #define BSP_VARIANT_DB500SYS
 #undef BSP_VARIANT_EB500HMI
 #undef BSP_VARIANT_NXFBCAI
#elif defined (INCLUDE_NETX_EB500HMI)
 #undef BSP_VARIANT_DB500SYS
 #define BSP_VARIANT_EB500HMI
 #undef BSP_VARIANT_NXFBCAI
#elif defined (INCLUDE_NETX_NXFBCAI)
 #undef BSP_VARIANT_DB500SYS
 #undef BSP_VARIANT_EB500HMI
 #define BSP_VARIANT_NXFBCAI
#else
 #define BSP_VARIANT_DB500SYS
 #undef BSP_VARIANT_EB500HMI
 #undef BSP_VARIANT_NXFBCAI
#endif
#else
#if defined(DB500SYS)
 #define BSP_VARIANT_DB500SYS
 #undef BSP_VARIANT_EB500HMI
 #undef BSP_VARIANT_NXFBCAI
#elif defined(EB500HMI)
 #undef BSP_VARIANT_DB500SYS
 #define BSP_VARIANT_EB500HMI
 #undef BSP_VARIANT_NXFBCAI
#elif defined(NXFBCAI)
 #undef BSP_VARIANT_DB500SYS
 #undef BSP_VARIANT_EB500HMI
 #define BSP_VARIANT_NXFBCAI
#else
 #define BSP_VARIANT_DB500SYS
 #undef BSP_VARIANT_EB500HMI
 #undef BSP_VARIANT_NXFBCAI
#endif
 
#endif


/** /BSP Variant Selection */

#ifdef __cplusplus
extern "C" {
#endif

#define TARGET_NETX


#if ! defined(_WRS_VXWORKS_MAJOR) 
    #define _WRS_VXWORKS_MAJOR  5
#endif

#if ! defined(_WRS_VXWORKS_MINOR)
    #define _WRS_VXWORKS_MINOR  5
#endif

#if ! defined(_WRS_VXWORKS_MAINT)
    #define _WRS_VXWORKS_MAINT  1
#endif

/*
 * It is not necessary to define SYS_FLASH_TYPE as FLASH_28F320 as
 * auto-identification correctly identifies the Flash part.
 */


/* NETX memory map */
#define LOCAL_MEM_HI_VEC_PADRS  (RAM_LOW_ADRS-0x1000)
#define LOCAL_MEM_HI_VEC_ADRS   0xFFFF0000
#define LOCAL_MEM_HI_VEC_SIZE   0x00001000

/*#define LOCAL_MEM_LO_VEC_PADRS  (RAM_LOW_ADRS-0x1000)*/
#define LOCAL_MEM_LO_VEC_PADRS  0x00000000
#define LOCAL_MEM_LO_VEC_ADRS   0x00000000
#define LOCAL_MEM_LO_VEC_SIZE   0x00001000

#define INTERNAL_SRAM_PADRS     0x00000000

#ifdef BOOTLOADER
    #define INTERNAL_SRAM_VADRS     INTERNAL_SRAM_PADRS
    #define INTERNAL_SRAM_UC_VADRS  INTERNAL_SRAM_PADRS
#else
 #if defined(_WRS_VXWORKS_MAJOR) && (6 == _WRS_VXWORKS_MAJOR)
    #define INTERNAL_SRAM_VADRS     0x88000000
    #define INTERNAL_SRAM_UC_VADRS  0xA8000000
 #elif defined(_WRS_VXWORKS_MAJOR) && (5 == _WRS_VXWORKS_MAJOR)
    #define INTERNAL_SRAM_VADRS     INTERNAL_SRAM_PADRS
    #define INTERNAL_SRAM_UC_VADRS  INTERNAL_SRAM_PADRS
 #else
    #error Check VxWorks Version !!!!!
 #endif
#endif

#define INTERNAL_SRAM_SIZE      0x00020000

#define GPIOVIC_PADRS           0x00020000
#ifdef BOOTLOADER
    #define GPIOVIC_VADRS           GPIOVIC_PADRS
#else
 #if defined(_WRS_VXWORKS_MAJOR) && (6 == _WRS_VXWORKS_MAJOR)
    #define GPIOVIC_VADRS           0xA8020000
 #elif defined(_WRS_VXWORKS_MAJOR) && (5 == _WRS_VXWORKS_MAJOR)
    #define GPIOVIC_VADRS           GPIOVIC_PADRS
 #else
    #error Check VxWorks Version !!!!!
 #endif
#endif
#define GPIOVIC_SIZE            0x001E0000

#define EXTERNAL_SRAM0_PADRS    0xC0000000
#ifdef BOOTLOADER
    #define EXTERNAL_SRAM0_VADRS    EXTERNAL_SRAM0_PADRS
    #define EXTERNAL_SRAM0_UC_VADRS EXTERNAL_SRAM0_PADRS
#else
 #if defined(_WRS_VXWORKS_MAJOR) && (6 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM0_VADRS    0x89000000
    #define EXTERNAL_SRAM0_UC_VADRS 0xA9000000
 #elif defined(_WRS_VXWORKS_MAJOR) && (5 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM0_VADRS    EXTERNAL_SRAM0_PADRS
    #define EXTERNAL_SRAM0_UC_VADRS EXTERNAL_SRAM0_PADRS
 #else
    #error Check VxWorks Version !!!!!
 #endif
#endif
#define EXTERNAL_SRAM0_SIZE     0x04000000

#define EXTERNAL_SRAM1_PADRS    0xC8000000
#ifdef BOOTLOADER
    #define EXTERNAL_SRAM1_VADRS    EXTERNAL_SRAM1_PADRS
    #define EXTERNAL_SRAM1_UC_VADRS EXTERNAL_SRAM1_PADRS
#else
 #if defined(_WRS_VXWORKS_MAJOR) && (6 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM1_VADRS    0x8D000000
    #define EXTERNAL_SRAM1_UC_VADRS 0xAD000000
 #elif defined(_WRS_VXWORKS_MAJOR) && (5 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM1_VADRS    EXTERNAL_SRAM1_PADRS
    #define EXTERNAL_SRAM1_UC_VADRS EXTERNAL_SRAM1_PADRS
 #else
    #error Check VxWorks Version !!!!!
 #endif
#endif
#define EXTERNAL_SRAM1_SIZE     0x04000000

#define EXTERNAL_SRAM2_PADRS    0xD0000000
#ifdef BOOTLOADER
    #define EXTERNAL_SRAM2_VADRS    EXTERNAL_SRAM2_PADRS
    #define EXTERNAL_SRAM2_UC_VADRS EXTERNAL_SRAM2_PADRS
#else
 #if defined(_WRS_VXWORKS_MAJOR) && (6 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM2_VADRS    0x91000000
    #define EXTERNAL_SRAM2_UC_VADRS 0xB1000000
 #elif defined(_WRS_VXWORKS_MAJOR) && (5 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM2_VADRS    EXTERNAL_SRAM2_PADRS
    #define EXTERNAL_SRAM2_UC_VADRS EXTERNAL_SRAM2_PADRS
 #else
    #error Check VxWorks Version !!!!!
 #endif
#endif
#define EXTERNAL_SRAM2_SIZE     0x04000000

#define EXTERNAL_SRAM3_PADRS    0xD8000000
#ifdef BOOTLOADER
    #define EXTERNAL_SRAM3_VADRS    EXTERNAL_SRAM3_PADRS
    #define EXTERNAL_SRAM3_UC_VADRS EXTERNAL_SRAM3_PADRS
#else
 #if defined(_WRS_VXWORKS_MAJOR) && (6 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM3_VADRS    0x95000000
    #define EXTERNAL_SRAM3_UC_VADRS 0xB5000000
 #elif defined(_WRS_VXWORKS_MAJOR) && (5 == _WRS_VXWORKS_MAJOR)
    #define EXTERNAL_SRAM3_VADRS    EXTERNAL_SRAM3_PADRS
    #define EXTERNAL_SRAM3_UC_VADRS EXTERNAL_SRAM3_PADRS
 #else
    #error Check VxWorks Version !!!!!
 #endif
#endif
#define EXTERNAL_SRAM3_SIZE     0x04000000
                                      
									/*0x00100000*/
#define NETX_ASIC_CTRL_OFFSET		(0x000E0000)
#define NETX_ASIC_CTRL_BASE_PADRS	(GPIOVIC_PADRS + NETX_ASIC_CTRL_OFFSET)
#define NETX_ASIC_CTRL_BASE_VADRS	(GPIOVIC_VADRS + NETX_ASIC_CTRL_OFFSET)
                                      
                                    /*0x00100800*/
#define NETX_GPIO_OFFSET            (0x000E0800)
#define NETX_GPIO_BASE_PADRS        (GPIOVIC_PADRS + NETX_GPIO_OFFSET)
#define NETX_GPIO_BASE_VADRS        (GPIOVIC_VADRS + NETX_GPIO_OFFSET)

                                    /*0x00100900*/
#define NETX_PIO_OFFSET             (0x000E0900)
#define NETX_PIO_BASE_PADRS         (GPIOVIC_PADRS + NETX_PIO_OFFSET)
#define NETX_PIO_BASE_VADRS         (GPIOVIC_VADRS + NETX_PIO_OFFSET)
                                      
									/*0x00100b00*/
#define NETX_MIIMU_OFFSET			(0x000E0B00)
#define NETX_MIIMU_BASE_PADRS		(GPIOVIC_PADRS + NETX_MIIMU_OFFSET)
#define NETX_MIIMU_BASE_VADRS		(GPIOVIC_VADRS + NETX_MIIMU_OFFSET)

                                    /*0x00100c00*/
#define NETX_SPI_OFFSET             (0x000E0C00)
#define NETX_SPI_BASE_PADRS         (GPIOVIC_PADRS + NETX_SPI_OFFSET)
#ifdef BOOTLOADER
    #define NETX_SPI_BASE_VADRS     NETX_SPI_BASE_PADRS
#else
    #define NETX_SPI_BASE_VADRS     (GPIOVIC_VADRS + NETX_SPI_OFFSET)
#endif 
                    
                                    /*0x00100d00*/
#define NETX_I2C_OFFSET             (0x000E0D00)
#define NETX_I2C_BASE_PADRS         (GPIOVIC_PADRS + NETX_I2C_OFFSET)
#ifdef BOOTLOADER
    #define NETX_I2C_BASE_VADRS     NETX_I2C_BASE_PADRS
#else
    #define NETX_I2C_BASE_VADRS     (GPIOVIC_VADRS + NETX_I2C_OFFSET)
#endif 

                                    /*0x001031DC*/
#define NETX_RES_REG_OFFSET         (0x000E31DC)

#define NETX_RES_REG_PADRS          (GPIOVIC_PADRS + NETX_RES_REG_OFFSET)
#define NETX_RES_REG_VADRS          (GPIOVIC_VADRS + NETX_RES_REG_OFFSET)

                                    /*0x00104000*/
#define NETX_LCD_CTRL_OFFSET        (0x000E4000)
#define NETX_LCD_CTRL_BASE_PADRS    (GPIOVIC_PADRS + NETX_LCD_CTRL_OFFSET)
#define NETX_LCD_CTRL_BASE_VADRS    (GPIOVIC_VADRS + NETX_LCD_CTRL_OFFSET)

                                    /*0x001ff000*/
#define NETX_VIC_OFFSET             (0x001DF000)
#define NETX_VIC_BASE_PADRS         (GPIOVIC_PADRS + NETX_VIC_OFFSET)
#define NETX_VIC_BASE_VADRS         (GPIOVIC_VADRS + NETX_VIC_OFFSET)
                                     
#define NETX_VIC_BASE_ADRS          (0x001ff000)
#define NETX_VIC_IRQ_ENABLE_OFFSET  0x10
#define NETX_VIC_IRQ_ENCLEAR_OFFSET 0x14
    
                                    /*0x00100800*/
#define NETX_UARTGPIO_OFFSET        (0x000E0800)
									
                                    /*0x00100a00*/
#define NETX_UART0_OFFSET           (0x000E0A00)
                                    /*0x00100a40*/
#define NETX_UART1_OFFSET           (0x000E0A40)
                                    /*0x00100a80*/
#define NETX_UART2_OFFSET           (0x000E0A80)
								
#define NETX_UART_GPIO_BASE_PADRS   (GPIOVIC_PADRS + NETX_UARTGPIO_OFFSET)
#define NETX_UART_GPIO_BASE_VADRS   (GPIOVIC_VADRS + NETX_UARTGPIO_OFFSET)

#define NETX_UART0_BASE_PADRS       (GPIOVIC_PADRS + NETX_UART0_OFFSET)
#define NETX_UART1_BASE_PADRS       (GPIOVIC_PADRS + NETX_UART1_OFFSET)
#define NETX_UART2_BASE_PADRS       (GPIOVIC_PADRS + NETX_UART2_OFFSET)

#define NETX_UART0_BASE_VADRS       (GPIOVIC_VADRS + NETX_UART0_OFFSET)
#define NETX_UART1_BASE_VADRS       (GPIOVIC_VADRS + NETX_UART1_OFFSET)
#define NETX_UART2_BASE_VADRS       (GPIOVIC_VADRS + NETX_UART2_OFFSET)
									/* 0x00101100 */
#define NETX_SYSTIME_OFFSET			(0x000E1100)
#define NETX_SYSTIME_BASE_PADRS		(GPIOVIC_PADRS + NETX_SYSTIME_OFFSET)
#define NETX_SYSTIME_BASE_VADRS		(GPIOVIC_VADRS + NETX_SYSTIME_OFFSET)

									/* 0x00160000 */
#define NETX_XMAC0_OFFSET			(0x00140000)
#define NETX_XMAC1_OFFSET			(0x00141000)
#define NETX_XMAC2_OFFSET			(0x00142000)
#define NETX_XMAC3_OFFSET			(0x00143000)

#define NETX_XMAC0_BASE_PADRS		(GPIOVIC_PADRS + NETX_XMAC0_OFFSET)
#define NETX_XMAC1_BASE_PADRS		(GPIOVIC_PADRS + NETX_XMAC1_OFFSET)
#define NETX_XMAC2_BASE_PADRS		(GPIOVIC_PADRS + NETX_XMAC2_OFFSET)
#define NETX_XMAC3_BASE_PADRS		(GPIOVIC_PADRS + NETX_XMAC3_OFFSET)

#define NETX_XMAC0_BASE_VADRS		(GPIOVIC_VADRS + NETX_XMAC0_OFFSET)
#define NETX_XMAC1_BASE_VADRS		(GPIOVIC_VADRS + NETX_XMAC1_OFFSET)
#define NETX_XMAC2_BASE_VADRS		(GPIOVIC_VADRS + NETX_XMAC2_OFFSET)
#define NETX_XMAC3_BASE_VADRS		(GPIOVIC_VADRS + NETX_XMAC3_OFFSET)

#define NETX_PTR_FIFO_OFFSET		(0x00144000)
#define NETX_XPEC0_IRQ_OFFSET		(0x00144400)
#define NETX_XPEC1_IRQ_OFFSET		(0x00144404)
#define NETX_XPEC2_IRQ_OFFSET		(0x00144408)
#define NETX_XPEC3_IRQ_OFFSET		(0x0014440C)

#define NETX_PTR_FIFO_PADRS			(GPIOVIC_PADRS + NETX_PTR_FIFO_OFFSET)
#define NETX_XPEC0_IRQ_PADRS		(GPIOVIC_PADRS + NETX_XPEC0_IRQ_OFFSET)
#define NETX_XPEC1_IRQ_PADRS		(GPIOVIC_PADRS + NETX_XPEC1_IRQ_OFFSET)
#define NETX_XPEC2_IRQ_PADRS		(GPIOVIC_PADRS + NETX_XPEC2_IRQ_OFFSET)
#define NETX_XPEC3_IRQ_PADRS		(GPIOVIC_PADRS + NETX_XPEC3_IRQ_OFFSET)

#define NETX_PTR_FIFO_VADRS			(GPIOVIC_VADRS + NETX_PTR_FIFO_OFFSET)
#define NETX_XPEC0_IRQ_VADRS		(GPIOVIC_VADRS + NETX_XPEC0_IRQ_OFFSET)
#define NETX_XPEC1_IRQ_VADRS		(GPIOVIC_VADRS + NETX_XPEC1_IRQ_OFFSET)
#define NETX_XPEC2_IRQ_VADRS		(GPIOVIC_VADRS + NETX_XPEC2_IRQ_OFFSET)
#define NETX_XPEC3_IRQ_VADRS		(GPIOVIC_VADRS + NETX_XPEC3_IRQ_OFFSET)

									/* 0x00170000 */
#define NETX_XPEC0_OFFSET			(0x00150000)
#define NETX_XPEC1_OFFSET			(0x00154000)
#define NETX_XPEC2_OFFSET			(0x00158000)
#define NETX_XPEC3_OFFSET			(0x0015C000)

#define NETX_XPEC0_BASE_PADRS		(GPIOVIC_PADRS + NETX_XPEC0_OFFSET)
#define NETX_XPEC1_BASE_PADRS		(GPIOVIC_PADRS + NETX_XPEC1_OFFSET)
#define NETX_XPEC2_BASE_PADRS		(GPIOVIC_PADRS + NETX_XPEC2_OFFSET)
#define NETX_XPEC3_BASE_PADRS		(GPIOVIC_PADRS + NETX_XPEC3_OFFSET)

#define NETX_XPEC0_BASE_VADRS		(GPIOVIC_VADRS + NETX_XPEC0_OFFSET)
#define NETX_XPEC1_BASE_VADRS		(GPIOVIC_VADRS + NETX_XPEC1_OFFSET)
#define NETX_XPEC2_BASE_VADRS		(GPIOVIC_VADRS + NETX_XPEC2_OFFSET)
#define NETX_XPEC3_BASE_VADRS		(GPIOVIC_VADRS + NETX_XPEC3_OFFSET)
    
#define NETX_SRAM0_OFFSET			(0x00000000)
#define NETX_SRAM1_OFFSET			(0x00008000)
#define NETX_SRAM2_OFFSET			(0x00010000)
#define NETX_SRAM3_OFFSET			(0x00018000)

#define NETX_SRAM0_PADRS			(INTERNAL_SRAM_PADRS + NETX_SRAM0_OFFSET)
#define NETX_SRAM1_PADRS			(INTERNAL_SRAM_PADRS + NETX_SRAM1_OFFSET)
#define NETX_SRAM2_PADRS			(INTERNAL_SRAM_PADRS + NETX_SRAM2_OFFSET)
#define NETX_SRAM3_PADRS			(INTERNAL_SRAM_PADRS + NETX_SRAM3_OFFSET)

#define NETX_SRAM0_VADRS			(INTERNAL_SRAM_VADRS + NETX_SRAM0_OFFSET)
#define NETX_SRAM1_VADRS			(INTERNAL_SRAM_VADRS + NETX_SRAM1_OFFSET)
#define NETX_SRAM2_VADRS			(INTERNAL_SRAM_VADRS + NETX_SRAM2_OFFSET)
#define NETX_SRAM3_VADRS			(INTERNAL_SRAM_VADRS + NETX_SRAM3_OFFSET)

#define NETX_SRAM0_UC_VADRS			(INTERNAL_SRAM_UC_VADRS + NETX_SRAM0_OFFSET)
#define NETX_SRAM1_UC_VADRS			(INTERNAL_SRAM_UC_VADRS + NETX_SRAM1_OFFSET)
#define NETX_SRAM2_UC_VADRS			(INTERNAL_SRAM_UC_VADRS + NETX_SRAM2_OFFSET)
#define NETX_SRAM3_UC_VADRS			(INTERNAL_SRAM_UC_VADRS + NETX_SRAM3_OFFSET)

#define NETX_PERIPHERAL_BASE	      0x10000000
#define NETX_PERIPHERAL_SIZE	      0x10000000

#define NETX_BOOT_ROM_LO            0x00000000
#define NETX_BOOT_ROM_HI            0x20000000
#define NETX_BOOT_ROM_BASE          NETX_BOOT_ROM_HI
#define NETX_BOOT_ROM_SIZE	      0x00080000

#define NETX_HNX_CORELOADER             NETX_BOOT_ROM_LO    /* Hilscher Core Loader */
#define NETX_ROM_BASE_ADRS              0x80000000      /* base of Pseudo ROM */

#if (defined BSP_VARIANT_NXFBCAI)
#define NETX_LOCAL_MEM_LOCAL_ADRS       0x80100000
#define NETX_LOCAL_MEM_LOCAL_UC_ADRS    0xA0100000

#define NETX_LOCAL_MEM_BUS_ADRS         0x80100000
#define NETX_LOCAL_MEM_SIZE             0x00700000

#define NETX_ROM_SIZE                   0x00100000      /* size of ROM holding VxWorks*/
#define NETX_ROM_SIZE_TOTAL             0x00100000      /* total size of ROM */
#define NETX_RAM_LOW_ADRS               0x80102000      /* VxWorks image entry point */
#define NETX_RAM_HIGH_ADRS              0x80680000      /* RAM address for ROM boot */

#elif (defined BSP_VARIANT_DB500SYS) || (defined BSP_VARIANT_EB500HMI)

#define NETX_LOCAL_MEM_LOCAL_ADRS       0x80200000
#define NETX_LOCAL_MEM_LOCAL_UC_ADRS    0xA0200000

#define NETX_LOCAL_MEM_BUS_ADRS         0x80200000
#define NETX_LOCAL_MEM_SIZE             0x01000000

#define NETX_ROM_SIZE                   0x00200000      /* size of ROM holding VxWorks*/
#define NETX_ROM_SIZE_TOTAL             0x00200000      /* total size of ROM */
#define NETX_RAM_LOW_ADRS               0x80202000      /* VxWorks image entry point */
#define NETX_RAM_HIGH_ADRS              0x807A0000      /* RAM address for ROM boot */

#else
#if !(defined PRJ_BUILD)
#error "Unknown hardware Platform"
#endif
#endif

/* Flash definitions */

#if defined (BSP_VARIANT_EB500HMI)
    #define FLASH_BASE              EXTERNAL_SRAM0_UC_VADRS         /* Base address of Flash part */
    #define FLASHSECTORS            128                             /* amount of sectors */
    #define FLASHSECTORSIZE         128*1024                        /* 128 kB per block */
    #define FLASH_WIDTH             2                               /* Two 16-bit wide parts */
    #define FLASH_CHIP_WIDTH        1
    
    #define FLASH_BLOCK_NUM         127                             /* 128 kB block used as NVRAM */

    #define TFFS_FLASH_BLOCK_NUM    0
    #define TFFS_FLASH_BLOCKS       126

    #define TFFS_WINDOWSIZE         FLASHSECTORSIZE
    
#elif defined(BSP_VARIANT_DB500SYS)
    #define FLASH_BASE              EXTERNAL_SRAM0_UC_VADRS         /* Base address of Flash part */
    #define FLASHSECTORS            255                             /* amount of sectors */
    #define FLASHSECTORSIZE         128*1024                        /* 128 kB per block */
    #define FLASH_WIDTH             4                               /* Two 16-bit wide parts */
    #define FLASH_CHIP_WIDTH        2
    
    #define FLASH_BLOCK_NUM         254                             /* 128 kB block used as NVRAM */

    #define TFFS_FLASH_BLOCK_NUM    0
    #define TFFS_FLASH_BLOCKS       253

    #define TFFS_WINDOWSIZE         FLASHSECTORSIZE

#elif defined(BSP_VARIANT_NXFBCAI)
    #define FLASH_BASE              0x00000000
    #define FLASHSECTORS            8192                           /* Two SPI Flashes and 8192 Pages per chip */
    #define FLASHSECTORSIZE         528                             /* 528 Bytes per page */
    #define FLASH_WIDTH             4                               /* Two 16-bit wide parts */
    #define FLASH_CHIP_WIDTH        2

    #define FLASH_NVRAM_SLAVEID     1
    #define FLASH_TRUEFFS_SLAVEID   2

    #define FLASH_BLOCK_NUM         8190                            /* 1 kB block used as NVRAM */
    
    #define TFFS_FLASH_BLOCK_NUM    0

    #define TFFS_FLASH_BLOCKS       8192                          /* blocks for tffs (*528 byte) */
    
    #define TFFS_FLASHSECTORSIZE    FLASHSECTORSIZE
    
    #define TFFS_WINDOWSIZE         0x1000

#else
#if !defined(PRJ_BUILD)
    #error You need to select a valid BSP Platform type
#endif
#endif

#define NETX_FLASH_SIZE             (FLASHSECTORS*FLASHSECTORSIZE)  /* Total Flash available. */
    

#define FLASH_ADRS		      (FLASH_BASE + (FLASH_BLOCK_NUM * FLASHSECTORSIZE))

#define TFFS_FLASH_ADRS               (FLASH_BASE + (TFFS_FLASH_BLOCK_NUM * TFFS_FLASHSECTORSIZE))
#define TFFS_FLASH_SIZE               (TFFS_FLASH_BLOCKS * TFFS_FLASHSECTORSIZE)

#define FLASH_WIDTH_SPECIAL_2	      /* see flash28.h */
#define SYS_FLASH_WRITE             /* use enable/disable routines*/


/*
 *  New Core Modules have different amounts of SSRAM,
 *  the amount of SSRAM fitted can be found in HDR_STAT.
 *
 *  The symbol NETX_SSRAM_SIZE is kept, however this
 *  now refers to the minimum amount of SSRAM fitted on any
 *  core module.
 *
 *  New Core Modules also alias the SSRAM.
 */

#define NETX_SSRAM_BASE           0x00000000
#define NETX_SSRAM_ALIAS_BASE     0x10800000
#define NETX_SSRAM_SIZE           SZ_256K

#define NETX_HDR_SSRAM_SIZE	SZ_1M

#define NETX_MBRD_SSRAM_BASE      0x28000000
#define NETX_MBRD_SSRAM_SIZE      SZ_512K

/*  SDRAM is a DIMM therefore the size is not known. */

#define NETX_SDRAM_BASE           0x00040000

#define NETX_SDRAM_ALIAS_BASE     0x80000000
#define NETX_HDR0_SDRAM_BASE      0x80000000
#define NETX_HDR1_SDRAM_BASE      0x90000000
#define NETX_HDR2_SDRAM_BASE      0xA0000000
#define NETX_HDR3_SDRAM_BASE      0xB0000000

/* RAM base in reset memory map */

#define NETX_RESET_RAM_BASE	0x28000000

/* Signals generated from NETX clock generator. */
                      
#define NETX_SYSCLK   100000000		/* System bus clock */
#define NETX_UARTCLK  100000000	    /* UART clock */
/*#define NETX_UARTCLK  NETX_SYSCLK / * UART clock * / */
#define NETX_CLK24MHZ 100000000  	/* KMI/Timer clock */


/* NETX 940T core module registers. */

#define NETX_HDR_ID_OFFSET        0x00
#define NETX_HDR_PROC_OFFSET      0x04
#define NETX_HDR_OSC_OFFSET       0x08
#define NETX_HDR_CTRL_OFFSET      0x0C
#define NETX_HDR_STAT_OFFSET      0x10
#define NETX_HDR_LOCK_OFFSET      0x14
#define NETX_HDR_SDRAM_OFFSET     0x20
#define NETX_HDR_INIT_OFFSET      0x24
#define NETX_HDR_IC_OFFSET        0x40
#define NETX_HDR_SPDBASE_OFFSET   0x100
#define NETX_HDR_SPDTOP_OFFSET    0x200

#define NETX_HDR_CTRL_FASTBUS	0x40

#define NETX_HDR_BASE             0x10000000
#define NETX_HDR_ID    (NETX_HDR_BASE + NETX_HDR_ID_OFFSET)
#define NETX_HDR_PROC  (NETX_HDR_BASE + NETX_HDR_PROC_OFFSET)
#define NETX_HDR_OSC   (NETX_HDR_BASE + NETX_HDR_OSC_OFFSET)
#define NETX_HDR_CTRL  (NETX_HDR_BASE + NETX_HDR_CTRL_OFFSET)
#define NETX_HDR_STAT  (NETX_HDR_BASE + NETX_HDR_STAT_OFFSET)
#define NETX_HDR_LOCK  (NETX_HDR_BASE + NETX_HDR_LOCK_OFFSET)
#define NETX_HDR_SDRAM (NETX_HDR_BASE + NETX_HDR_SDRAM_OFFSET)
#define NETX_HDR_INIT  (NETX_HDR_BASE + NETX_HDR_INIT_OFFSET)
#define NETX_HDR_IC    (NETX_HDR_BASE + NETX_HDR_IC_OFFSET)
#define NETX_HDR_SPDBASE \
			(NETX_HDR_BASE + NETX_HDR_SPDBASE_OFFSET)
#define NETX_HDR_SPDTOP \
			(NETX_HDR_BASE + NETX_HDR_SPDTOP_OFFSET)

#define NETX_HDR_OSC_CORE_10MHz	(0x102)
#define NETX_HDR_OSC_CORE_15MHz	(0x107)
#define NETX_HDR_OSC_CORE_20MHz	(0x10C)
#define NETX_HDR_OSC_CORE_25MHz	(0x111)
#define NETX_HDR_OSC_CORE_30MHz	(0x116)
#define NETX_HDR_OSC_CORE_35MHz	(0x11B)
#define NETX_HDR_OSC_CORE_40MHz	(0x120)
#define NETX_HDR_OSC_CORE_45MHz	(0x125)
#define NETX_HDR_OSC_CORE_50MHz	(0x12A)
#define NETX_HDR_OSC_CORE_55MHz	(0x12F)
#define NETX_HDR_OSC_CORE_60MHz	(0x134)
#define NETX_HDR_OSC_CORE_65MHz	(0x139)
#define NETX_HDR_OSC_CORE_70MHz	(0x13E)
#define NETX_HDR_OSC_CORE_75MHz	(0x143)
#define NETX_HDR_OSC_CORE_80MHz	(0x148)
#define NETX_HDR_OSC_CORE_85MHz	(0x14D)
#define NETX_HDR_OSC_CORE_90MHz	(0x152)
#define NETX_HDR_OSC_CORE_95MHz	(0x157)
#define NETX_HDR_OSC_CORE_100MHz	(0x15C)
#define NETX_HDR_OSC_CORE_105MHz	(0x161)
#define NETX_HDR_OSC_CORE_110MHz	(0x166)
#define NETX_HDR_OSC_CORE_115MHz	(0x16B)
#define NETX_HDR_OSC_CORE_120MHz	(0x170)
#define NETX_HDR_OSC_CORE_125MHz	(0x175)
#define NETX_HDR_OSC_CORE_130MHz	(0x17A)
#define NETX_HDR_OSC_CORE_135MHz	(0x17F)
#define NETX_HDR_OSC_CORE_140MHz	(0x184)
#define NETX_HDR_OSC_CORE_145MHz	(0x189)
#define NETX_HDR_OSC_CORE_150MHz	(0x18E)
#define NETX_HDR_OSC_CORE_155MHz	(0x193)
#define NETX_HDR_OSC_CORE_160MHz	(0x198)
#define NETX_HDR_OSC_CORE_MASK	(0x7FF)

#define NETX_HDR_OSC_MEM_10MHz	(0x10C000)
#define NETX_HDR_OSC_MEM_15MHz	(0x116000)
#define NETX_HDR_OSC_MEM_20MHz	(0x120000)
#define NETX_HDR_OSC_MEM_25MHz	(0x12A000)
#define NETX_HDR_OSC_MEM_30MHz	(0x134000)
#define NETX_HDR_OSC_MEM_33MHz	(0x13A000)
#define NETX_HDR_OSC_MEM_40MHz	(0x148000)
#define NETX_HDR_OSC_MEM_50MHz	(0x15C000)
#define NETX_HDR_OSC_MEM_60MHz	(0x170000)
#define NETX_HDR_OSC_MEM_66MHz	(0x17C000)
#define NETX_HDR_OSC_MEM_MASK	(0x7FF000)

/*
 * Values we use for core and memory clocks on different header cards. Later
 * versions of cards and/or upgraded FPGAs on the boards may enable the cards
 * to run at faster speeds.
 *
 * These are:
 *
 * Processor    Core    Memory Bus   System Bus   PCI Bus
 * =========    ====    ==========   ==========   =======
 * Unknown      40MHz      20MHz        20MHz      33MHz
 * ARM720T      50MHz      40MHz        20MHz      33MHz
 * ARM740T      50MHz      40MHz        20MHz      33MHz
 * ARM920T     140MHz      25MHz        20MHz      33MHz
 * ARM940T     100MHz      25MHz        20MHz      33MHz
 * ARM946ES    100MHz      25MHz        20MHz      33MHz
 * ARM926ES    100MHz      25MHz        20MHz      33MHz
 * ARM966ES    120MHz      40MHz        20MHz      33MHz
 * ARM1136JF   100MHz      25MHz        20MHz      33MHz
 *
 * NOTE
 * ====
 * The memory bus frequency of 25 MHz for ARM 9 cores is a very
 * conservative figure. Depending on silicon manufacturer and version, it may
 * be possible to select a higher frequency by experimentation.
 */

#define NETX_HDR_OSC_DFLT_VAL \
		(NETX_HDR_OSC_CORE_40MHz | NETX_HDR_OSC_MEM_20MHz)
#define NETX_HDR_OSC_926ES_VAL \
	        (NETX_HDR_OSC_CORE_80MHz | NETX_HDR_OSC_MEM_25MHz)


#define NETX_HDR_REMAP		0x4
#if 0

#define NETX_HDR_SDRAM_SPD_OK	0x20

#define NETX_HDR_PLLBYPASS_ON	0x3
#define NETX_HDR_HCLKDIV_3	0x20
#define NETX_HDR_CLKRATIO_2	0x100
#define NETX_HDR_TCRAM_ENABLE	0x10000
#define NETX_HDR_TCRAM_EMULATE	0x20000
#endif

/* NETX EBI register definitions. */

#define NETX_EBI_BASE               0x12000000

#define NETX_EBI_CSR0_OFFSET      0x00
#define NETX_EBI_CSR1_OFFSET      0x04
#define NETX_EBI_CSR2_OFFSET      0x08
#define NETX_EBI_CSR3_OFFSET      0x0C
#define NETX_EBI_LOCK_OFFSET      0x20

#define NETX_EBI_CSR0 (NETX_EBI_BASE + NETX_EBI_CSR0_OFFSET)
#define NETX_EBI_CSR1 (NETX_EBI_BASE + NETX_EBI_CSR1_OFFSET)
#define NETX_EBI_CSR2 (NETX_EBI_BASE + NETX_EBI_CSR2_OFFSET)
#define NETX_EBI_CSR3 (NETX_EBI_BASE + NETX_EBI_CSR3_OFFSET)
#define NETX_EBI_LOCK (NETX_EBI_BASE + NETX_EBI_LOCK_OFFSET)


#define NETX_EBI_8_BIT            0x00
#define NETX_EBI_16_BIT           0x01
#define NETX_EBI_32_BIT           0x02
#define NETX_EBI_WRITE_ENABLE     0x04
#define NETX_EBI_SYNC             0x08
#define NETX_EBI_WS_2             0x00
#define NETX_EBI_WS_3             0x10
#define NETX_EBI_WS_4             0x20
#define NETX_EBI_WS_5             0x30
#define NETX_EBI_WS_6             0x40
#define NETX_EBI_WS_7             0x50
#define NETX_EBI_WS_8             0x60
#define NETX_EBI_WS_9             0x70
#define NETX_EBI_WS_10            0x80
#define NETX_EBI_WS_11            0x90
#define NETX_EBI_WS_12            0xA0
#define NETX_EBI_WS_13            0xB0
#define NETX_EBI_WS_14            0xC0
#define NETX_EBI_WS_15            0xD0
#define NETX_EBI_WS_16            0xE0
#define NETX_EBI_WS_17            0xF0

/* System Controller */

#define NETX_SC_ID_OFFSET		(0x00)
#define NETX_SC_OSC_OFFSET	(0x04)
#define NETX_SC_CTRLS_OFFSET	(0x08)
#define NETX_SC_CTRLC_OFFSET	(0x0C)
#define NETX_SC_DEC_OFFSET	(0x10)
#define NETX_SC_ARB_OFFSET	(0x14)
#define NETX_SC_PCIENABLE_OFFSET	(0x18)
#define NETX_SC_LOCK_OFFSET	(0x1C)

#define NETX_SC_BASE		(0x11000000)
#define NETX_SC_ID \
			(NETX_SC_BASE + NETX_SC_ID_OFFSET)
#define NETX_SC_OSC \
			(NETX_SC_BASE + NETX_SC_OSC_OFFSET)
#define NETX_SC_CTRLS \
			(NETX_SC_BASE + NETX_SC_CTRLS_OFFSET)
#define NETX_SC_CTRLC \
			(NETX_SC_BASE + NETX_SC_CTRLC_OFFSET)
#define NETX_SC_DEC \
			(NETX_SC_BASE + NETX_SC_DEC_OFFSET)
#define NETX_SC_ARB \
			(NETX_SC_BASE + NETX_SC_ARB_OFFSET)
#define NETX_SC_PCIENABLE \
			(NETX_SC_BASE + NETX_SC_PCIENABLE_OFFSET)
#define NETX_SC_LOCK \
			(NETX_SC_BASE + NETX_SC_LOCK_OFFSET)


#define NETX_SC_OSC_SYS_10MHz	(0x20)
#define NETX_SC_OSC_SYS_15MHz	(0x34)
#define NETX_SC_OSC_SYS_20MHz	(0x48)
#define NETX_SC_OSC_SYS_25MHz	(0x5C)
#define NETX_SC_OSC_SYS_33MHz	(0x7C)
#define NETX_SC_OSC_SYS_MASK	(0xFF)

#define NETX_SC_OSC_PCI_25MHz	(0x100)
#define NETX_SC_OSC_PCI_33MHz	(0x0)
#define NETX_SC_OSC_PCI_MASK	(0x100)

#define FL_SC_CONTROL			0x06	/* Enable Flash Write and Vpp */

/* - Hard coded id of the core module we are compiling for. */

#define CORE_MODULE 0

#define VIC_INT_NUM_LEVELS	32

/* Interrupt levels */

#define INT_LVL_SOFT		 0	/* Reserved for Software Interrupt, ARM standard configuration  */
#define INT_LVL_TIMER_0		 1	/* Timer0 / Counter0 from GPIO Module -> Real time operating system timer */
#define INT_LVL_TIMER_1		 2	/* Timer1 / Counter1 from GPIO Module -> AucClk Timer */
#define INT_LVL_TIMER_2		 3	/* Timer2 / Counter2 from GPIO Module */
#define INT_LVL_SYSTIME_NS   4  /* systime ns compare irq from GPIO module */
#define INT_LVL_SYSTIME_S    5  /* systime 1day IRQ from SYSTIME module */
#define INT_LVL_GPIO15       6  /* external interrupt 15 (NMI) */
#define INT_LVL_WATCHDOG     7  /* reserved */
#define INT_LVL_UART_0  	 8	/* UART 0 */
#define INT_LVL_UART_1		 9	/* UART 1 */
#define INT_LVL_UART_2	    10	/* UART 2 */
#define INT_LVL_USB         11  /* USB interrupt */
#define INT_LVL_SPI         12  /* SPI interrupt */
#define INT_LVL_I2C         13  /* reserved */
#define INT_LVL_LCD         14  /* LCD-Controller interrupt */
#define INT_LVL_HIF_PCI     15  /* PCI / HIF interrupt */
#define INT_LVL_GPIO        16  /* other external Interrupts from GPIO 0-14 */
#define INT_LVL_COM0        17  /* Communication channel 0 (= |xpec0_irq[11:0]) */
#define INT_LVL_COM1        18  /* Communication channel 1 (= |xpec1_irq[11:0]) */
#define INT_LVL_COM2        19  /* Communication channel 2 (= |xpec2_irq[11:0]) */
#define INT_LVL_COM3        20  /* Communication channel 3 (= |xpec3_irq[11:0]) */
#define INT_LVL_MSYNC0      21  /* Motion synchronization channel 0 (= |xpec0_irq[15:12]) */
#define INT_LVL_MSYNC1      22  /* Motion synchronization channel 1 (= |xpec1_irq[15:12]) */
#define INT_LVL_MSYNC2      23  /* Motion synchronization channel 2 (= |xpec2_irq[15:12]) */
#define INT_LVL_MSYNC3      24  /* Motion synchronization channel 3 (= |xpec3_irq[15:12]) */
#define INT_LVL_INT_PHY     25  /* Interrupt from internal Phys */
#define INT_LVL_ISO_AREA    26  /* Power is going down (see RTC for details) */
#define INT_LVL_RESVD0      27  /* reserved */
#define INT_LVL_RESVD1      28  /* reserved */
#define INT_LVL_TIMER_3		29	/* Timer3 / Counter3 from GPIO Module */
#define INT_LVL_TIMER_4		30	/* Timer4 / Counter4 from GPIO Module */
#define INT_LVL_VFP9        31  /* reserved */

/* interrupt vectors */

#define INT_VEC_SOFT		IVEC_TO_INUM(INT_LVL_SOFT	    )
#define INT_VEC_TIMER_0		IVEC_TO_INUM(INT_LVL_TIMER_0	)
#define INT_VEC_TIMER_1		IVEC_TO_INUM(INT_LVL_TIMER_1	)
#define INT_VEC_TIMER_2		IVEC_TO_INUM(INT_LVL_TIMER_2	)
#define INT_VEC_SYSTIME_NS	IVEC_TO_INUM(INT_LVL_SYSTIME_NS )
#define INT_VEC_SYSTIME_S 	IVEC_TO_INUM(INT_LVL_SYSTIME_S  )
#define INT_VEC_GPIO15    	IVEC_TO_INUM(INT_LVL_GPIO15     )
#define INT_VEC_WATCHDOG  	IVEC_TO_INUM(INT_LVL_WATCHDOG   )
#define INT_VEC_UART_0      IVEC_TO_INUM(INT_LVL_UART_0     )
#define INT_VEC_UART_1		IVEC_TO_INUM(INT_LVL_UART_1	    )
#define INT_VEC_UART_2	  	IVEC_TO_INUM(INT_LVL_UART_2	    )
#define INT_VEC_USB       	IVEC_TO_INUM(INT_LVL_USB        )
#define INT_VEC_SPI       	IVEC_TO_INUM(INT_LVL_SPI        )
#define INT_VEC_I2C       	IVEC_TO_INUM(INT_LVL_I2C        )
#define INT_VEC_LCD       	IVEC_TO_INUM(INT_LVL_LCD        )
#define INT_VEC_HIF_PCI   	IVEC_TO_INUM(INT_LVL_HIF_PCI    )
#define INT_VEC_GPIO      	IVEC_TO_INUM(INT_LVL_GPIO       )
#define INT_VEC_COM0      	IVEC_TO_INUM(INT_LVL_COM0       )
#define INT_VEC_COM1        IVEC_TO_INUM(INT_LVL_COM1       )
#define INT_VEC_COM2      	IVEC_TO_INUM(INT_LVL_COM2       )
#define INT_VEC_COM3      	IVEC_TO_INUM(INT_LVL_COM3       )
#define INT_VEC_MSYNC0      IVEC_TO_INUM(INT_LVL_MSYNC0     )
#define INT_VEC_MSYNC1      IVEC_TO_INUM(INT_LVL_MSYNC1     )
#define INT_VEC_MSYNC2      IVEC_TO_INUM(INT_LVL_MSYNC2     )
#define INT_VEC_MSYNC3      IVEC_TO_INUM(INT_LVL_MSYNC3     )
#define INT_VEC_INT_PHY     IVEC_TO_INUM(INT_LVL_INT_PHY    )
#define INT_VEC_ISO_AREA    IVEC_TO_INUM(INT_LVL_ISO_AREA   )
#define INT_VEC_RESVD0      IVEC_TO_INUM(INT_LVL_RESVD0     )
#define INT_VEC_RESVD1      IVEC_TO_INUM(INT_LVL_RESVD1     )
#define INT_VEC_TIMER_3	    IVEC_TO_INUM(INT_LVL_TIMER_3	)
#define INT_VEC_TIMER_4	    IVEC_TO_INUM(INT_LVL_TIMER_4	)
#define INT_VEC_VFP9        IVEC_TO_INUM(INT_LVL_VFP9       )

/* definitions for the AMBA UART */

#define UART_XTAL_FREQ		NETX_UARTCLK            /* UART baud rate clk freq */

#if defined(BSP_VARIANT_DB500SYS)
    #define N_NETX_UART_CHANNELS	3		            /* number of NETX UART chans */
#elif defined(BSP_VARIANT_EB500HMI)
    #define N_NETX_UART_CHANNELS	1		            /* number of NETX UART chans */
#elif defined(BSP_VARIANT_NXFBCAI)
    #define N_NETX_UART_CHANNELS	1		            /* number of NETX UART chans */
#else
#if !(defined PRJ_BUILD)
    #error You need to select a valid BSP Platform type
#endif
#endif

#define N_SIO_CHANNELS		N_NETX_UART_CHANNELS
#define N_UART_CHANNELS		N_NETX_UART_CHANNELS

/*

/ * definitions for the AMBA Timer * /

#define AMBA_TIMER_BASE		0x13000000	/ * Address of base of timer * /
#define AMBA_BASE_OFFSET        0X100


#define AMBA_TIMER0_BASE ((AMBA_TIMER_BASE))
#define AMBA_TIMER1_BASE ((AMBA_TIMER_BASE) + AMBA_BASE_OFFSET)
#define AMBA_TIMER2_BASE ((AMBA_TIMER_BASE) + 2 * AMBA_BASE_OFFSET)

#define SYS_TIMER_BASE   AMBA_TIMER1_BASE
#define AUX_TIMER_BASE   AMBA_TIMER0_BASE
#define SLEEP_TIMER_BASE AMBA_TIMER2_BASE
*/




#define SYS_TIMER_INT_LVL   (INT_LVL_TIMER_0)
#define AUX_TIMER_INT_LVL   (INT_LVL_TIMER_1)
#define SLEEP_TIMER_INT_LVL (INT_LVL_TIMER_2)
#define TS_TIMER_INT_LVL    (INT_LVL_TIMER_2)

/* Add corresponding INT_VEC definitions for intConnect calls. */

#define SYS_TIMER_INT_VEC (INT_VEC_TIMER_0)
#define AUX_TIMER_INT_VEC (INT_VEC_TIMER_1)
#define TS_TIMER_INT_VEC  (INT_VEC_TIMER_2)

/*
#define NETX_TIMER_SYS_TC_DISABLE	(TC_DISABLE | TC_PERIODIC | TC_DIV16)
#define NETX_TIMER_SYS_TC_ENABLE	(TC_ENABLE  | TC_PERIODIC | TC_DIV16)
#define NETX_TIMER_AUX_TC_DISABLE	(TC_DISABLE | TC_PERIODIC | TC_DIV16)
#define NETX_TIMER_AUX_TC_ENABLE	(TC_ENABLE  | TC_PERIODIC | TC_DIV16)
*/

/* Frequency of counter/timers */

#define SYS_TIMER_CLK	(NETX_SYSCLK)
#define AUX_TIMER_CLK	(NETX_SYSCLK)
#define SLEEP_TIMER_CLK (NETX_SYSCLK)

#define NETX_RELOAD_TICKS	0	/* No overhead */

/* Mask out unused bits from timer register. */

#define NETX_TIMER_VALUE_MASK	0xFFFFFFFF


/*
*  Note: the numbering below is 1,2,3 instead of 0,1,2.
* This matches the definitions in ambaTimer.h
*/

/* Sys Clk is timer 2 */

#define SYS_TIMER_CLEAR AMBA_TIMER_T2CLEAR
#define SYS_TIMER_CTRL  AMBA_TIMER_T2CTRL
#define SYS_TIMER_LOAD  AMBA_TIMER_T2LOAD
#define SYS_TIMER_VALUE AMBA_TIMER_T2VALUE

/* Aux Clk is timer 1 */

#define AUX_TIMER_CLEAR AMBA_TIMER_T1CLEAR
#define AUX_TIMER_CTRL  AMBA_TIMER_T1CTRL
#define AUX_TIMER_LOAD  AMBA_TIMER_T1LOAD
#define AUX_TIMER_VALUE AMBA_TIMER_T1VALUE

/* Sleep Clk is timer 3 */

#define SLEEP_TIMER_CLEAR AMBA_TIMER_T3CLEAR
#define SLEEP_TIMER_CTRL  AMBA_TIMER_T3CTRL
#define SLEEP_TIMER_LOAD  AMBA_TIMER_T3LOAD
#define SLEEP_TIMER_VALUE AMBA_TIMER_T3VALUE

/*
 * Clock rates depend upon CPU power and work load of application.
 * The values below are minimum and maximum allowed by the hardware.
 * So:
 * min frequency = roundup(clock_rate/(max_counter_value))
 * max frequency = rounddown(clock_rate/(min_counter_value))
 * i.e. SYS_CLK_RATE_MAX = SYS_TIMER_CLK
 *      AUX_CLK_RATE_MAX = AUX_TIMER_CLK
 *
 * However, we must set maxima that are sustainable on a running
 * system determined by experimentation.
 *
 * The 720T values have been determined by experimentation, the others
 * need to be checked.
 */

                            /* 10Hz */
#define SYS_CLK_RATE_MIN (10)
                            /* 10kHz */
#define SYS_CLK_RATE_MAX (10000)

#define AUX_CLK_RATE_MIN (10)
#define AUX_CLK_RATE_MAX (10000)


/* Bit field definitions */

#define BIT0                            0x00000001
#define BIT1                            0x00000002
#define BIT2                            0x00000004
#define BIT3                            0x00000008
#define BIT4                            0x00000010
#define BIT5                            0x00000020
#define BIT6                            0x00000040
#define BIT7                            0x00000080
#define BIT8                            0x00000100
#define BIT9                            0x00000200
#define BIT10                           0x00000400
#define BIT11                           0x00000800
#define BIT12                           0x00001000
#define BIT13                           0x00002000
#define BIT14                           0x00004000
#define BIT15                           0x00008000
#define BIT16                           0x00010000
#define BIT17                           0x00020000
#define BIT18                           0x00040000
#define BIT19                           0x00080000
#define BIT20                           0x00100000

/* Handy sizes */

#define SZ_1K                           0x00000400
#define SZ_4K                           0x00001000
#define SZ_8K                           0x00002000
#define SZ_16K                          0x00004000
#define SZ_64K                          0x00010000
#define SZ_128K                         0x00020000
#define SZ_256K                         0x00040000
#define SZ_512K                         0x00080000

#define SZ_1M                           0x00100000
#define SZ_2M                           0x00200000
#define SZ_4M                           0x00400000
#define SZ_8M                           0x00800000
#define SZ_16M                          0x01000000
#define SZ_32M                          0x02000000
#define SZ_64M                          0x04000000
#define SZ_128M                         0x08000000
#define SZ_256M                         0x10000000
#define SZ_512M                         0x20000000

#define SZ_1G                           0x40000000
#define SZ_2G                           0x80000000

#define TYPE_ALLOC	1000

/*
 * Definitions for Ethernet driver buffer use.
 *
 * The buffers to be shared across the PCI bus in must not have addresses
 * in low memory which refer to header card SSRAM (which is not
 * reachable from the PCI bus). We can do several things:
 *
 * 1. Simply allow the driver to use use cacheDmaMalloc() without
 * checking the addresses returned. Because of where the heap usually
 * is, cacheDmaMalloc() in default kernels will generally return
 * addresses which are "low-aliases" for SDRAM and not header card SSRAM.
 * To use this option, do not define NETX_ENET_FIXED_BUF_ADRS and do
 * not define the parameter NETX_ENET_CHECK_BUFFERS. Header cards for
 * later CPUs may have more local SSRAM, so this may become more of a problem
 * with those later cards.
 *
 * 2. Use cacheDmaMalloc() in the BSP initialisation code, but check that the
 * memory returned is not, in fact, SSRAM, but is actually SDRAM. To use this
 * option define the parameter NETX_ENET_CHECK_BUFFERS. A disadvantage
 * of this is that the BSP then needs knowledge of the relationship between
 * buffer space required and the numbers of transmit and receive buffers to be
 * allocated, which would normally be kept within the driver. This is the
 * option configured by default.
 *
 * 3. Define the buffer address to be a specific address, which is
 * accessible from the PCI bus.
 * (a) One possibility is the unaliased SDRAM at its real (high) address.
 * To use this option, define NETX_ENET_FIXED_BUF_ADRS and define
 * NETX_XXX_BUF_ADRS to be NETX_SDRAM_ALIAS_BASE.
 * All of the SDRAM is mapped at the high address, but the size of the
 * part that is not aliased down to low memory, will be the size of the
 * header card SSRAM. On 720T, there is 256 Kbytes and on 920T, we have 1
 * megabyte.
 * (b) Another possibility is the motherboard SSRAM, though early
 * motherboards have a fault that prevents this SSRAM from being accessed
 * from PCI unless the FPGAs on the board have been upgraded. To use this
 * option, define NETX_ENET_FIXED_BUF_ADRS and define
 * NETX_ENET_XXX_BUF_ADRS to be NETX_MBRD_SSRAM_ALIAS_BASE
 * (+ offset if required).
 *
 * In the FEI driver, we use ((nCFDs + 5*nRFDs) * 1544) + 4 bytes.
 * On 720T, this is more than the size of the unaliased SDRAM (256 kbytes),
 * so if we use that area, we need to adjust the number of CFDs and
 * RFDs downwards slightly.
 *
 * Note that all of the fixed address options listed above will suffer a
 * performance penalty over using low-aliased-SDRAM.
 *
 * 4. Reserve an area of SDRAM (at the low alias, but above the end of
 * header card SSRAM) to use for the buffer memory.
 *
 * The drivers will check that the amount of memory given is sufficient
 * for the numbers of CFDs and RFDs and will fail to load if there is a
 * mismatch.
 *
 * Obviously, if only one of the FEI and DEC drivers is being used, then buffer
 * space need only be allocated for the one being used.
 */

#undef  NETX_ENET_FIXED_BUF_ADRS	/* do not use fixed address bufs */
#undef NETX_ENET_CHECK_BUFFERS	/* check cacheDmaMalloc() addresses */


#ifdef  NETX_ENET_FIXED_BUF_ADRS

/*
 * Provide definitions for the buffer address for the three possible PCI cards.
 * The SDRAM alias address should be available on all boards.
 */

#define NETX_ENET_PRIMARY_BUF_ADRS NETX_SDRAM_ALIAS_BASE

/* next two areas require a later board, or the FPGAs to have been upgraded */

#define NETX_ENET_SECONDARY_BUF_ADRS NETX_MBRD_SSRAM_BASE
#define NETX_ENET_TERTIARY_BUF_ADRS (NETX_MBRD_SSRAM_BASE + 0x40000)
#endif /* NETX_ENET_FIXED_BUF_ADRS */


#define NETX_DEC_BUF_SIZE	0x30000

/*
 * Assuming we are on a 720T, and three drivers are being started, the
 * smallest slot is 256 kbytes, so reduce memory usage to fit into 256 Kbyte
 * slot. This can be overridden, if we know differently.
 */

#if defined (NETX_ENET_FIXED_BUF_ADRS)
#define NETX_FEI_BUF_SIZE	0x40000
#define NETX_FEI_NUM_CFDS	28
#define NETX_FEI_NUM_RFDS	28
#else
#define NETX_FEI_BUF_SIZE	0x49000
#define NETX_FEI_NUM_CFDS	32
#define NETX_FEI_NUM_RFDS	32
#endif


/*
 * Max number of END devices we support - we currently set to three for
 * three PCI slots.
 */

#define NETX_MAX_END_DEVS 4

/*
 * Max number of VGA devices we support - we currently set to three for
 * three PCI slots.
 */

#define NETX_MAX_VGA_DEVS 3


/* Definitions for LED controller and sysLedsReadWrite */

#define LED_BASE        0x1A000000
#define LED_ALPHA 	    (LED_BASE + 0x00)
#define LED_LIGHTS	    (LED_BASE + 0x04)
#define LED_SWITCHES	(LED_BASE + 0x08)

#define LED_STATUS	0x01

#define LED_0		0x01
#define LED_1		0x02
#define LED_2		0x04
#define LED_4		0x08

#define LED_LEDS_MASK	0x0F


#define ARM966_I_SRAM_ENABLE    (1<<12)
#define ARM966_WBUFF_ENABLE     (1<<3)
#define ARM966_D_SRAM_ENABLE    (1<<2)

/* definition for power management instrumentation */
#ifdef POWER_MGT_INSTRUMENT
#define SYS_CLK_INT_ENABLE_ENTRY_INDICATOR     UINT16 leds; \
    AMBA_TIMER_READ(LED_LIGHTS,leds); \
    leds = leds ^ LED_1; \
    AMBA_TIMER_WRITE(LED_LIGHTS, leds);

#define SYS_ONE_SHOT_ENABLE_ENTRY_INDICATOR     UINT16 leds; \
    AMBA_TIMER_READ(LED_LIGHTS,leds); \
    leds = leds | LED_0; \
    AMBA_TIMER_WRITE(LED_LIGHTS, leds);
#define SYS_ONE_SHOT_DISABLE_EXIT_INDICATOR
    AMBA_TIMER_READ(LED_LIGHTS,leds); \
    leds = leds & ~LED_0; \
    AMBA_TIMER_WRITE(LED_LIGHTS, leds);
#endif

#ifndef _ASMLANGUAGE
#ifdef INCLUDE_POWER_MGMT_CPU_BSP_SUPPORT
IMPORT void sysCpuPwrEnable (void);
#endif


#endif /* _ASMLANGUAGE */

#ifdef __cplusplus
}
#endif

#endif	/* INCNETXh */
